import os
import sys
import json
import getpass
import inspect
import logging
import subprocess
import platform

script_name = inspect.getfile(inspect.currentframe())
current_dir = os.path.dirname(os.path.abspath(script_name))
iw_installer_dir = current_dir
iw_installer_libs_dir = os.path.abspath(os.path.join(iw_installer_dir, 'resources', 'python-libs'))
sys.path.insert(0, iw_installer_dir)
sys.path.insert(1, iw_installer_libs_dir)

from core import logger
from core import iw_constants
from core.iw_utils import IWUtils
from core.iw_authentication import aes_encrypt


logger.setup_logger(IWUtils.get_installer_log_file_path(), IWUtils.get_installer_log_config_path())


def get_hcat_home(dist_home, hive_home):

    hcatalog_home = None

    if os.path.isdir(os.path.join(dist_home, "hive-hcatalog")):
        hcatalog_home = os.path.join(dist_home, "hive-hcatalog")

    elif os.path.isdir(os.path.join(dist_home, "hive-webhcat")):
        hcatalog_home = os.path.join(dist_home, "hive-webhcat")

    elif os.path.isdir(os.path.join(hive_home, "hcatalog")):
        hcatalog_home = os.path.join(hive_home, "hcatalog")

    elif os.path.exists(os.path.join(os.path.join(dist_home, "hive"), "hiveversion")):
        with open(os.path.join(os.path.join(dist_home, "hive"), "hiveversion")) as fil:
            hivevrs = fil.read()
            hivevrs = hivevrs.strip()

        if os.path.isdir(os.path.join(os.path.join(os.path.join(dist_home, "hive"), "hive-{}".format(hivevrs), "hcatalog"))):
            hcatalog_home = os.path.join(os.path.join(os.path.join(dist_home, "hive"), "hive-{}".format(hivevrs), "hcatalog"))

    else:
        logging.warn('Unable to locate HCatalog Home')
        logging.info('Enter the path to HCatalog Home: ')
        hcatalog_home = input().strip()

    return hcatalog_home


with open("system-config.json", "r") as jfil:
    filedata = json.load(jfil)

dist = None
dist_home = None

print("")

if os.path.isdir("/usr/hdp"):
    if "azure" in platform.release():
        dist = "azure"
    else:
        dist = "hdp"
    dist_home = "/usr/hdp"

    print("Is {} installed under {}? y or n".format(dist, dist_home))
    yorn = input().strip()
    if yorn == "n":
        print("Enter location where {} is installed".format(dist))
        dist_home = input().strip()

elif os.path.isdir("/opt/mapr"):
    dist = "mapr"
    dist_home = "/opt/mapr"

    print("Is {} installed under {}? y or n".format(dist, dist_home))
    yorn = input().strip()
    if yorn == "n":
        print("Enter location where {} is installed".format(dist))
        dist_home = input().strip()


elif os.path.isdir("/opt/cloudera"):
    dist = "cloudera"
    dist_home = "/opt/cloudera"

    print("Is {} installed under {}? y or n".format(dist, dist_home))
    yorn = input().strip()
    if yorn == "n":
        print("Enter location where {} is installed".format(dist))
        dist_home = input().strip()

elif os.path.exists("/var/aws/emr/bigtop-deploy") or os.path.exists("/usr/share/aws/emr"):
    dist = "emr"
    dist_home = "/usr/lib"
    print("Detected EMR installation")
    print("Are hadoop components setup under {}? y or n".format(dist_home))
    yorn = input().strip()
    if yorn == "n":
        print("Enter location where hadoop components are installed")
        dist_home = input().strip()

elif os.path.isdir("/usr/lib/google-cloud-sdk/lib/surface/dataproc") or os.path.isdir('/usr/local/share/google/dataproc'):
    dist = "gcp"
    dist_home = "/usr/lib"
    print("Detected GCP installation")
    print("Are hadoop components setup under {}? y or n".format(dist_home))
    yorn = input().strip()
    if yorn == "n":
        print("Enter location where hadoop components are installed")
        dist_home = input().strip()

else:
    if not dist:
        print("Enter distribution name: (hdp, mapr, cloudera, gcp, emr or azure)")
        dist = input().strip()
        print("Enter distribution home path:")
        dist_home = input().strip()
        print("")


filedata["target_configurations"]["distro"] = dist
filedata["target_configurations"]["dist_home"] = dist_home

if dist == "hdp" or dist == "azure":
    filedata["target_configurations"]["hbase_home"] = "{}/current/hbase-client".format(dist_home)
    if not os.path.isdir(filedata["target_configurations"]["hbase_home"]):
        filedata["target_configurations"]["hbase_home"] = ""

    filedata["target_configurations"]["hive_home"] =  "{}/current/hive-client".format(dist_home)
    filedata["target_configurations"]["hive_conf"] = os.path.join(filedata["target_configurations"]["hive_home"], "conf")
    filedata["target_configurations"]["hive_lib"] = os.path.join(filedata["target_configurations"]["hive_home"], "lib")

    filedata["target_configurations"]["hadoop_home"] = "{}/current/hadoop-client".format(dist_home)
    filedata["target_configurations"]["hadoop_conf"] = os.path.join(filedata["target_configurations"]["hadoop_home"], "conf")
    filedata["target_configurations"]["hadoop_lib"] = os.path.join(filedata["target_configurations"]["hadoop_home"], "lib")

    filedata["target_configurations"]["spark_home"] = "{}/current/spark2-client".format(dist_home)

    if not os.path.isdir(filedata["target_configurations"]["spark_home"]):
        filedata["target_configurations"]["spark_home"] = ""
        filedata["target_configurations"]["spark_conf"] = ""
        filedata["target_configurations"]["spark_lib"] = ""

    else:
        filedata["target_configurations"]["spark_conf"] = os.path.join(filedata["target_configurations"]["spark_home"], "conf")
        filedata["target_configurations"]["spark_lib"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                       "jars")

elif dist == "mapr":
    if os.path.exists("{}/hbase/hbaseversion".format(dist_home)):
        hbase_version = None
        with open("{}/hbase/hbaseversion".format(dist_home)) as fil:
            hbase_version = fil.read()
        hbase_version = hbase_version.strip()

        filedata["target_configurations"]["hbase_home"] = "{}/hbase/hbase-{}".format(dist_home, hbase_version)

    else:
        filedata["target_configurations"]["hbase_home"] = ""

    hive_version = None
    with open("{}/hive/hiveversion".format(dist_home)) as fil:
        hive_version = fil.read()
    hive_version = hive_version.strip()

    filedata["target_configurations"]["hive_home"] = "{}/hive/hive-{}".format(dist_home, hive_version)
    filedata["target_configurations"]["hive_conf"] = os.path.join(filedata["target_configurations"]["hive_home"], "conf")
    filedata["target_configurations"]["hive_lib"] = os.path.join(filedata["target_configurations"]["hive_home"], "lib")

    hadoop_version = None
    with open("{}/hadoop/hadoopversion".format(dist_home)) as fil:
        hadoop_version = fil.read()
    hadoop_version = hadoop_version.strip()

    filedata["target_configurations"]["hadoop_home"] = "{}/hadoop/hadoop-{}".format(dist_home, hadoop_version)
    filedata["target_configurations"]["hadoop_conf"] = os.path.join(os.path.join(filedata["target_configurations"]["hadoop_home"], "etc"), "hadoop")
    filedata["target_configurations"]["hadoop_lib"] = "{}/share/hadoop/mapreduce/lib".format(filedata["target_configurations"]["hadoop_home"])

    if os.path.exists(IWUtils.get_mapr_spark_installation_path(dist_home)):
        spark_home = None
        spark_version = None
        spark_version_file = IWUtils.get_mapr_spark_version_file(dist_home)
        if os.path.exists(spark_version_file):
            with open(spark_version_file) as fil:
                spark_version = fil.read()
            spark_version = spark_version.strip()
            spark_home = os.path.join(dist_home, 'spark', 'spark-{}'.format(spark_version))
        else:
            print(('Unable to locate spark home directory. Please provide the path to spark home: '))
            spark_home = input().strip()

        filedata["target_configurations"]["spark_home"] = spark_home
        filedata["target_configurations"]["spark_conf"] = os.path.join(spark_home, 'conf')
        filedata["target_configurations"]["spark_lib"] = os.path.join(spark_home, 'jars')

    else:
        filedata["target_configurations"]["spark_home"] = ""
        filedata["target_configurations"]["spark_conf"] = ""
        filedata["target_configurations"]["spark_lib"] = ""


elif dist=="cloudera":
    filedata["target_configurations"]["hbase_home"] = "{}/parcels/CDH/lib/hbase".format(dist_home)
    if not os.path.isdir(filedata["target_configurations"]["hbase_home"]):
        filedata["target_configurations"]["hbase_home"] = ""

    filedata["target_configurations"]["hive_home"] = "{}/parcels/CDH/lib/hive".format(dist_home)
    filedata["target_configurations"]["hive_conf"] = os.path.join(filedata["target_configurations"]["hive_home"], "conf")
    filedata["target_configurations"]["hive_lib"] = os.path.join(filedata["target_configurations"]["hive_home"], "lib")

    filedata["target_configurations"]["hadoop_home"] = "{}/parcels/CDH/lib/hadoop".format(dist_home)
    filedata["target_configurations"]["hadoop_conf"] = "{}/etc/hadoop".format(filedata["target_configurations"]["hadoop_home"])
    filedata["target_configurations"]["hadoop_lib"] = os.path.join(filedata["target_configurations"]["hadoop_home"], "lib")

    filedata["target_configurations"]["spark_home"] = "{}/parcels/SPARK2/lib/spark2".format(dist_home)

    if not os.path.isdir(filedata["target_configurations"]["spark_home"]):
        filedata["target_configurations"]["spark_home"] = ""
        filedata["target_configurations"]["spark_conf"] = ""
        filedata["target_configurations"]["spark_lib"] = ""

    else:
        filedata["target_configurations"]["spark_conf"] = os.path.join(filedata["target_configurations"]["spark_home"], "conf")
        filedata["target_configurations"]["spark_lib"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                       "jars")

elif dist=="gcp":

    filedata["target_configurations"]["hbase_home"] = "{}/hbase".format(dist_home)
    if not os.path.isdir(filedata["target_configurations"]["hbase_home"]):
        filedata["target_configurations"]["hbase_home"] = ""

    filedata["target_configurations"]["hive_home"] = "{}/hive".format(dist_home)
    filedata["target_configurations"]["hive_conf"] = os.path.join(filedata["target_configurations"]["hive_home"],"conf")
    filedata["target_configurations"]["hive_lib"] = os.path.join(filedata["target_configurations"]["hive_home"], "lib")

    filedata["target_configurations"]["hadoop_home"] = "{}/hadoop".format(dist_home)
    filedata["target_configurations"]["hadoop_conf"] = "{}/etc/hadoop".format(filedata["target_configurations"]["hadoop_home"])
    filedata["target_configurations"]["hadoop_lib"] = os.path.join(filedata["target_configurations"]["hadoop_home"],"lib")

    filedata["target_configurations"]["spark_home"] = "{}/spark".format(dist_home)

    if not os.path.isdir(filedata["target_configurations"]["spark_home"]):
        filedata["target_configurations"]["spark_home"] = ""
        filedata["target_configurations"]["spark_conf"] = ""
        filedata["target_configurations"]["spark_lib"] = ""

    else:
        filedata["target_configurations"]["spark_conf"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                       "conf")
        filedata["target_configurations"]["spark_lib"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                      "jars")

elif dist=="emr":

    filedata["target_configurations"]["hbase_home"] = "{}/hbase".format(dist_home)
    if not os.path.isdir(filedata["target_configurations"]["hbase_home"]):
        filedata["target_configurations"]["hbase_home"] = ""

    filedata["target_configurations"]["hive_home"] = "{}/hive".format(dist_home)
    filedata["target_configurations"]["hive_conf"] = os.path.join(filedata["target_configurations"]["hive_home"],"conf")
    filedata["target_configurations"]["hive_lib"] = os.path.join(filedata["target_configurations"]["hive_home"], "lib")

    filedata["target_configurations"]["hadoop_home"] = "{}/hadoop".format(dist_home)
    filedata["target_configurations"]["hadoop_conf"] = "{}/etc/hadoop".format(filedata["target_configurations"]["hadoop_home"])
    filedata["target_configurations"]["hadoop_lib"] = os.path.join(filedata["target_configurations"]["hadoop_home"],"lib")

    filedata["target_configurations"]["spark_home"] = "{}/spark".format(dist_home)

    if not os.path.isdir(filedata["target_configurations"]["spark_home"]):
        filedata["target_configurations"]["spark_home"] = ""
        filedata["target_configurations"]["spark_conf"] = ""
        filedata["target_configurations"]["spark_lib"] = ""

    else:
        filedata["target_configurations"]["spark_conf"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                       "conf")
        filedata["target_configurations"]["spark_lib"] = os.path.join(filedata["target_configurations"]["spark_home"],
                                                                      "jars")

#sets hcat_home

hcat_home = get_hcat_home(os.path.dirname(filedata["target_configurations"]["hadoop_home"]), filedata["target_configurations"]["hive_home"])
print("")

filedata["target_configurations"]["hcat_home"] = hcat_home
filedata["target_configurations"]["hcat_lib"] = os.path.join(os.path.join(hcat_home, "share"), "hcatalog")
filedata["target_configurations"]["hcat_conf"] = os.path.join(os.path.join(filedata["target_configurations"]["hcat_home"], "etc"), "hcatalog")

print("")
detected_user = subprocess.check_output(["whoami"]).strip().decode("utf-8")
detected_group = subprocess.check_output(["id", "-gn"]).strip().decode("utf-8")
print("Enter user name to set up Infoworks on edge node. Press enter to use current user {}".format(detected_user))
user_name = input().strip()

if user_name=="":
    user_name = detected_user
    print("Using current user: {}".format(user_name))
    print("")

print("Enter group name to use for current user. Press enter to use current group {}".format(detected_group))
group_name = input().strip()

if group_name=="":
    group_name = detected_group
    print("Using current group: {}".format(group_name))

filedata["user_name"] = user_name
filedata["group_name"] = group_name

print("")
print("Enter path of directory where you want Infoworks to be installed: (ex: /opt/infoworks)")
iw_home = input().strip()

if iw_home=="":
    iw_home = "/opt/infoworks"
    print("Using: {}".format(iw_home))

filedata["target_configurations"]["iw_home"] = iw_home
filedata["target_configurations"]["infoworks_home"] = iw_home

print("")
print("Enter path of directory for home folder for Infoworks artifacts: (Infoworks HDFS home)")
iw_hdfs_home = input().strip()
if iw_hdfs_home=="":
    iw_hdfs_home = "/user/{}".format(user_name)
    print("Using: {}".format(iw_hdfs_home))
filedata["target_configurations"]["infoworks_hdfs_home"] = iw_hdfs_home


print("")
print("Enter the hive schema to store Infoworks sample data: (ex: iw_df_workspace)")
iw_df_schema = input().strip()
if iw_df_schema=="":
    iw_df_schema = "iw_df_workspace"
    print("Using: {}".format(iw_df_schema))
filedata["target_configurations"]["infoworks_df_schema"] = iw_df_schema


print("")
int_ip = subprocess.check_output(["hostname", "-f"]).strip().decode("utf-8")
print("Enter the hostname/ip which will be used when accessing the Infoworks UI via the browser (when in doubt use the fqdn of the Infoworks host)")
ext_ip = input().strip()

if ext_ip == "":
    ext_ip = int_ip
    print("Using default value: {}".format(ext_ip))

filedata["target_configurations"]["external_ip"] = ext_ip
filedata["target_configurations"]["internal_ip"] = int_ip


print("")
print("Please choose whether you wish to provide (1/2) \n1. HiveServer2 thrift server URL\n2. Zookeeper URL")
try:
    hive_input_type = int(input().strip())
except ValueError:
    print("Invalid input")
    hive_input_type = 1
    filedata["target_configurations"]["hive_input_type"] = "hiveserver2"
if hive_input_type != 2:
    hive_input_type = 1
    print("Taking default as HiveServer2 thrift server")
    filedata["target_configurations"]["hive_input_type"] = "hiveserver2"
else:
    filedata["target_configurations"]["hive_input_type"] = "zookeeper"

if hive_input_type == 1:
    print("")
    print("Enter the HiveServer2 thrift server hostname (this hostname must have a dns/hosts file entry for resolution). hive.server2.transport.mode must be set to binary mode on this server and the HiveServer2 thrift must be listening on port 10000:")
    print("(ex: hive2://<ip-address>:10000)")
    hs_hostname = input().strip()
    if hs_hostname == "":
        hs_hostname = subprocess.check_output(["hostname", "-f"]).strip().decode("utf-8")
        hs_hostname = "hive2://{}:10000".format(hs_hostname)
        print("Taking default {}".format(hs_hostname))
elif hive_input_type == 2:
    print("")
    print(
        "Enter the Zookeeper URL (this hostname must have a dns/hosts file entry for resolution)")
    print("(ex: hive2://<ip-address>:2181/;serviceDiscoveryMode=zooKeeper;zooKeeperNamespace=hiveserver2)")
    zookeeper_url = input().strip()
    if zookeeper_url == "":
        zookeeper_url = subprocess.check_output(["hostname", "-f"]).strip().decode("utf-8")
        zookeeper_url = "hive2://{}:2181/;serviceDiscoveryMode=zooKeeper;zooKeeperNamespace=hiveserver2".format(zookeeper_url)
        print("Taking default {}".format(zookeeper_url))

print("")
print("Enter the username which will be used by Infoworks for accessing hive. This username must belong to a group present in hadoop.proxyuser.hive.groups: ")
hs_user = input().strip()
if hs_user=="":
    hs_user = subprocess.check_output(["whoami"]).strip().decode("utf-8")
    print("Taking default {}".format(hs_user))

print("")
hs_pass = ""
if sys.stdin.isatty():
    hs_pass = getpass.getpass("Enter the password for the username {} for accessing hive: ".format(hs_user))
else:
    print("Enter the password for the username {} for accessing hive: ".format(hs_user))
    hs_pass = sys.stdin.readline().rstrip()
print("")

enc_hs_pass = aes_encrypt(hs_pass)

if hive_input_type == 2:
    filedata["target_configurations"]["zookeeper_url"] = zookeeper_url
    filedata["target_configurations"]["hiveserver"] = "{{HIVESERVER}}"
else:
    filedata["target_configurations"]["hiveserver"] = hs_hostname
filedata["target_configurations"]["hive_user"] = hs_user
filedata["target_configurations"]["hive_password"] = enc_hs_pass

if dist == iw_constants.HadoopDistribution.GCP:
    print("Enter the managed mongo url")
    managed_mongo_url = input().strip()
    if managed_mongo_url == "":
        managed_mongo_url = subprocess.check_output(["hostname", "-f"]).strip().decode("utf-8")
        print("Taking default {}".format(managed_mongo_url))
    filedata["target_configurations"]["managed_mongo_url"] = managed_mongo_url
    print("")
    print("Does {} already have infoworks directories extracted? (Y/N)\nIf N, infoworks package will be downloaded and extracted to {}\nIf Y, this step will be skipped".format(iw_home, iw_home))
    skip_infoworks_download = input().strip()
    if skip_infoworks_download == "":
        print("Taking default N")
        skip_infoworks_download = "N"
    filedata["target_configurations"]["skip_infoworks_download"] = skip_infoworks_download
    print("")

if dist == iw_constants.HadoopDistribution.CLOUDERA:
    print("Enter Impala hostname:")
    impala_hostname = input().strip()
    print("")

    print("Enter Impala port:")
    impala_port = input().strip()
    print("")

    print("Enter Impala user name:")
    impala_user = input().strip()
    print("")

    impala_password = None
    if sys.stdin.isatty():
        impala_password = getpass.getpass(
            "Enter Impala password for the username {}: ".format(impala_user))
    else:
        print("Enter the password for the username {} for accessing hive: ".format(impala_user))
        impala_password = sys.stdin.readline().rstrip()
    print("")

    enc_impala_pass = aes_encrypt(impala_password)

    filedata["target_configurations"]["impala_user"] = impala_user
    filedata["target_configurations"]["impala_hostname"] = impala_hostname
    filedata["target_configurations"]["impala_port"] = impala_port
    filedata["target_configurations"]["impala_password"] = enc_impala_pass

    print("Is Impala kerberised? y or n: ")
    krb = input().strip()
    print("")

    if krb == 'y' or krb == 'Y':
        print("Enter Kerberos realm:")
        krb_realm = input().strip()
        print("")

        print("Enter Kerberos host FQDN:")
        krb_host_fqdn = input().strip()
        print("")

        filedata["target_configurations"]["krb_realm"] = krb_realm
        filedata["target_configurations"]["krb_host_fqdn"] = krb_host_fqdn

print("************************************************SUMMARY************************************************")
print("Summary of all values entered:")
print("*******************************************************************************************************")
print("")
print("Hadoop distribution home: {}".format(dist_home))
print("User name: {}".format(user_name))
print("Group name: {}".format(group_name))
print("Infoworks install directory: {}".format(iw_home))
print("Infoworks HDFS home directory: {}".format(iw_hdfs_home))
print("Hive schema for IW sample data: {}".format(iw_df_schema))
if hive_input_type == 1:
    print("Hive server: {}".format(hs_hostname))
else:
    print("Zookeeper URL: {}".format(zookeeper_url))
print("Hive username: {}".format(hs_user))
if dist == iw_constants.HadoopDistribution.GCP:
    print("Managed Mongo URL: {}".format(managed_mongo_url))
    print("Skip Infoworks Download: {}".format(skip_infoworks_download))
if dist == iw_constants.HadoopDistribution.CLOUDERA:
    print("Impala hostname: {}".format(impala_hostname))
    print("Impala port: {}".format(impala_port))
    print("Impala username: {}".format(impala_user))

    if krb in ['y', 'Y']:
        print("Kerberos realm: {}".format(krb_realm))
        print("Kerberos host FQDN: {}".format(krb_host_fqdn))

print("")

with open("system-config.json", "w") as jfil:
    json.dump(filedata, jfil, indent=4)
