import inspect
import json
import os
import subprocess
import sys

script_name = inspect.getfile(inspect.currentframe())
current_dir = os.path.dirname(os.path.abspath(script_name))
iw_installer_dir = current_dir
iw_installer_libs_dir = os.path.abspath(os.path.join(iw_installer_dir, 'resources', 'python-libs'))
sys.path.insert(0, iw_installer_dir)
sys.path.insert(1, iw_installer_libs_dir)

from core import logger
from core.iw_utils import IWUtils

logger.setup_logger(IWUtils.get_installer_log_file_path(), IWUtils.get_installer_log_config_path())

with open("system-config-saas.json", "r") as jfil:
    filedata = json.load(jfil)

user_name = subprocess.check_output(["whoami"]).strip().decode("utf-8")
group_name = subprocess.check_output(["id", "-gn"]).strip().decode("utf-8")
filedata["user_name"] = user_name
filedata["group_name"] = group_name
filedata["target_configurations"]["distro"] = "saas"

iw_home = "/opt/infoworks"
filedata["target_configurations"]["iw_home"] = iw_home
filedata["target_configurations"]["infoworks_home"] = iw_home

iw_df_schema = "iw_dt_workspace"
filedata["target_configurations"]["infoworks_df_schema"] = iw_df_schema

int_ip = subprocess.check_output(["hostname", "-f"]).strip().decode("utf-8")
ext_ip = int_ip

filedata["target_configurations"]["external_ip"] = ext_ip
filedata["target_configurations"]["internal_ip"] = int_ip

edge_node_ip = IWUtils.read_iw_edgenode_ip()
edge_node_port = "3000"
filedata["target_configurations"]["iw_edgenode_ip"] = edge_node_ip
filedata["target_configurations"]["iw_edgenode_port"] = edge_node_port

# databricks configs
databricks_iw_home = "/infoworks"
filedata["target_configurations"]["databricks_iw_home"] = databricks_iw_home

iw_platform = IWUtils.read_iw_platform()
filedata["target_configurations"]["iw_platform"] = iw_platform

if iw_platform == "marketplace":
    print("DataFoundry dir already exists, proceeding with the starting the services")
    skip_infoworks_download = "Y"
    filedata["target_configurations"]["skip_infoworks_download"] = skip_infoworks_download
    print("Skipping download and Extraction of DataFoundry")


db_url = IWUtils.read_databricks_url()
filedata["target_configurations"]["db_url"] = db_url

db_token = IWUtils.read_databricks_token()
filedata["target_configurations"]["db_token"] = db_token

db_region = IWUtils.read_databricks_region()
filedata["target_configurations"]["db_region"] = db_region

# License configs
iw_installation_id = IWUtils.read_iw_installation_id()
filedata["target_configurations"]["iw_installation_id"] = iw_installation_id

iw_license = IWUtils.read_iw_license()
filedata["target_configurations"]["iw_license"] = iw_license

iw_user = IWUtils.read_iw_user()
filedata["target_configurations"]["iw_user"] = iw_user

iw_ui_user = IWUtils.read_iw_ui_user()
filedata["target_configurations"]["iw_ui_user"] = iw_ui_user

iw_ui_password = IWUtils.read_iw_ui_password()
filedata["target_configurations"]["iw_ui_password"] = iw_ui_password

iw_admin_auth_token = IWUtils.read_iw_admin_auth_token()
filedata["target_configurations"]["iw_admin_auth_token"] = iw_admin_auth_token

iw_db_cluster_instance_type = IWUtils.read_cluster_instance_type()
filedata["target_configurations"]["iw_db_cluster_instance_type"] = iw_db_cluster_instance_type

iw_db_cluster_name = IWUtils.read_cluster_name()
filedata["target_configurations"]["iw_db_cluster_name"] = iw_db_cluster_name

iw_db_cluster_min_workers = IWUtils.read_cluster_min_workers()
filedata["target_configurations"]["iw_db_cluster_min_workers"] = iw_db_cluster_min_workers

iw_db_cluster_max_workers = IWUtils.read_cluster_max_workers()
filedata["target_configurations"]["iw_db_cluster_max_workers"] = iw_db_cluster_max_workers

iw_db_cluster_timeout = IWUtils.read_cluster_timeout()
filedata["target_configurations"]["iw_db_cluster_timeout"] = iw_db_cluster_timeout

iw_reporting_url = IWUtils.read_reporting_url()
filedata["target_configurations"]["iw_reporting_url"] = iw_reporting_url

iw_reporting_token = IWUtils.read_reporting_token()
filedata["target_configurations"]["iw_reporting_token"] = iw_reporting_token

iw_workspace_name = IWUtils.read_workspace_name()
filedata["target_configurations"]["iw_workspace_name"] = iw_workspace_name

db_platform = IWUtils.read_db_platform()
filedata["target_configurations"]["db_platform"] = db_platform

demo_assets = IWUtils.read_demo_assets()
filedata["target_configurations"]["demo_assets"] = demo_assets

mode = IWUtils.read_iw_mode()
filedata["target_configurations"]["iw_mode"] = mode

iw_signup_user = IWUtils.read_iw_signup_user()
filedata["target_configurations"]["iw_signup_user"] = iw_signup_user

iw_user_auth_token = IWUtils.read_iw_user_auth_token()
filedata["target_configurations"]["iw_user_auth_token"] = iw_user_auth_token

iw_sign_password = IWUtils.read_iw_signup_password()
filedata["target_configurations"]["iw_signup_password"] = iw_sign_password

cluster_pool_required = IWUtils.read_cluster_pool_required()
filedata["target_configurations"]["cluster_pool_required"] = cluster_pool_required

cluster_pool_name = IWUtils.read_cluster_pool_name()
filedata["target_configurations"]["cluster_pool_name"] = cluster_pool_name

cluster_pool_instance_type = IWUtils.read_cluster_pool__instance_type()
filedata["target_configurations"]["cluster_pool_instance_type"] = cluster_pool_instance_type

cluster_pool_idle_instances = IWUtils.read_cluster_pool_idle_instances()
filedata["target_configurations"]["cluster_pool_idle_instances"] = cluster_pool_idle_instances

cluster_pool_max_instances = IWUtils.read_cluster_pool_max_instances()
filedata["target_configurations"]["cluster_pool_max_instances"] = cluster_pool_max_instances

cluster_pool_auto_termination_minutes = IWUtils.read_cluster_pool_auto_termination_minutes()
filedata["target_configurations"]["cluster_pool_auto_termination_minutes"] = cluster_pool_auto_termination_minutes

ssl_setup = IWUtils.read_setup_ssl_flag()
filedata["target_configurations"]["ssl_setup"] = ssl_setup

systemd_setup = IWUtils.read_setup_systemd_flag()
filedata["target_configurations"]["systemd_setup"] = systemd_setup


print("************************************************SUMMARY************************************************")
print("*******************************************************************************************************")
print("")
print("IW Platform: {}".format(iw_platform))
print("Mode : {}".format(mode))
print("User name: {}".format(user_name))
print("Group name: {}".format(group_name))
print("IW user name: {}".format(iw_user))
print("Internal IP: {}".format(int_ip))
print("Edge node IP: {}".format(edge_node_ip))
print("Edge node Access Port: {}".format(edge_node_port))
print("Infoworks install directory: {}".format(iw_home))
print("Databricks IW home directory: {}".format(databricks_iw_home))
print("Databricks access URL: {}".format(db_url))
print("Databricks region: {}".format(db_region))
print("Databricks access token: {}".format(db_token))
print("IW Installation ID: {}".format(iw_installation_id))
print("IW License: {}".format(iw_license))
print("IW UI username: {}".format(iw_ui_user))
print("IW SIGNUP username: {}".format(iw_signup_user))
print("IW hashed password: {}".format(iw_ui_password))
print("IW_SIGNUP hashed password: {}".format(iw_sign_password))
print("IW admin auth token: {}".format(iw_admin_auth_token))
print("IW user auth token: {}".format(iw_user_auth_token))
print("DB cluster instance type: {}".format(iw_db_cluster_instance_type))
print("DB cluster min workers: {}".format(iw_db_cluster_min_workers))
print("DB cluster max workers: {}".format(iw_db_cluster_max_workers))
print("DB cluster timeout: {}".format(iw_db_cluster_timeout))
print("IW reporting URL: {}".format(iw_reporting_url))
print("IW reporting token: {}".format(iw_reporting_token))
print("DB platform: {}".format(db_platform))
print("Is Cluster_pool_required: {}".format(cluster_pool_required))
print("Cluster_pool_name: {}".format(cluster_pool_name))
print("Cluster_pool_instance_type: {}".format(cluster_pool_instance_type))
print("Cluster_pool_idle_instances: {}".format(cluster_pool_idle_instances))
print("Cluster_pool_mac_instances: {}".format(cluster_pool_max_instances))
print("Cluster_pool_auto_termination_minutes".format(cluster_pool_auto_termination_minutes))
print("Systemd Setup".format(ssl_setup))
print("SSL Nginx Setup ".format(systemd_setup))

# TODO add print methods for new variables

with open("system-config-saas.json", "w") as jfil:
    json.dump(filedata, jfil, indent=4)
