#!/bin/bash

source /opt/infoworks/bin/env.sh

if [ ! $1 ]; then
   echo " Example of use: $0 database_name [dir_to_store]"
   exit 1
fi

db=$1
out_dir=$2

if [ ! $out_dir ]; then
        out_dir="./"
else
        mkdir -p $out_dir
fi

tmp_file="temp-file.js"

echo "print('_ ' + db.getCollectionNames())" > $tmp_file

cols=`mongo -u infoworks -p IN11**rk $db $tmp_file | grep '_' | awk '{print $2}' | tr ',' ' '`
for c in $cols
do
    mongoexport -u infoworks -p IN11**rk -d $db -c $c -o "$out_dir/${c}.json"
done

rm $tmp_file