SCRIPT_LOC="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

args=$@

# get the linux type

if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
elif [ -f /etc/lsb-release ]; then
    # For some versions of Debian/Ubuntu without lsb_release command
    . /etc/lsb-release
    OS=$DISTRIB_ID
elif [ -f /etc/debian_version ]; then
    # Older Debian/Ubuntu/etc.
    OS=Debian
elif [ -f /etc/redhat-release ]; then
    # Older Red Hat, CentOS, etc.
    OS=CentOS
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    echo "Fall back to uname -s to detect OS version"
    OS=$(uname -s)
fi

if [ "$OS" = "CentOS" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36/bin
elif [ "$OS" = "Ubuntu" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-ubuntu/bin
elif [ "$OS" = "Debian GNU/Linux" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-debian/bin
elif [ "$OS" == "SLES" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-suse/bin
else
  export PY_PATH=${SCRIPT_LOC}/resources/python36/bin
fi

echo "Found OS: ${OS}"
echo "Using Python Path: ${PY_PATH}"

export PATH=$PY_PATH:$PATH

found_version=0
for i in "$@" ; do
    if [ $found_version -eq 1 ]; then
       VERSION_NO=$i
       break
    fi
    if [[ $i == "-v" ]] ; then
        found_version=1
    fi
done

# Print usage in case parameters are empty
if [ -z "$VERSION_NO" ]
then
   	echo "Usage: $0 -v <upgrade version> (./update.sh -v 2.7.2) [--certificate-check=false|true]"
   	exit 1
fi

ENV_FOR_INSTALL=`echo ${VERSION_NO} | grep -`

if [ -z $ENV_FOR_INSTALL ]; then
    if [ -d /usr/hdp ]; then
        dist=hdp
        azure_dist=$(echo -e "import platform\nprint(platform.release())" | python | cut -f3 -d'-')
        if [ "$azure_dist" == "azure" ]; then
            package_env=azure
        fi
        if [ -z $package_env ]; then
            if [ -d /etc/os-release ]; then
                rhel_version=$(cat /etc/os-release | grep VERSION_ID | cut -d \"=\" -f 2)
            elif [ -d /etc/redhat-release ]; then
                rhel_version=$(cat /etc/redhat-release |  awk '{{print $3}}' | cut -f1 -d .)
            else
                rhel_version=$(lsb_release -r | awk '{{print $2}}' | cut -f1 -d .)
            fi
            if [ -z $rhel_version ]; then
                echo "Unable to detect package. Please enter environment"
                read package_env
            else
                package_env="hdp-rhel""${rhel_version}"
            fi
        fi
        if [ -z $package_env ]; then
            echo "Unable to detect package. Please enter environment"
            read package_env
        fi
    elif [ -d /opt/mapr ]; then
        package_env=mapr
    elif [ -d /opt/cloudera ]; then
        package_env=cdh
    elif [ -d /var/aws/emr/bigtop-deploy -o -d /usr/share/aws/emr ]; then
        package_env=emr
    elif [ -d /usr/local/share/google/dataproc -o -d /usr/lib/google-cloud-sdk/lib/surface/dataproc ]; then
        package_env=gcp
    elif [ "$OS" == "SLES" ]; then
        package_env=hdp-suse12
    else
        echo "Unable to detect package. Please enter environment"
        read package_env
    fi
    args=$(echo "${args/$VERSION_NO/${VERSION_NO}-$package_env}")
    echo "Using package" ${VERSION_NO}-$package_env
    sleep 3
fi

if [[ "$IW_PLATFORM" = "saas" || "$IW_PLATFORM" = "marketplace" ]]; then
    echo "Found IW_PLATFORM: saas"
    python ${SCRIPT_LOC}/installer/driver_saas.py $args
else
    python ${SCRIPT_LOC}/installer/driver.py $args
fi
exit $?
