#!/bin/bash

_get_hadoop_spark_home() {
	environment=$1
	if [ $environment = "cdh" ]; then
		if [[ -z "${HADOOP_HOME}" ]]; then
			echo "Hadoop home not set as environmental variable"
			pushd ~ 1>/dev/null
			BASH_FILE=.bashrc
			if grep -q "HADOOP_HOME" "$BASH_FILE"; then
				echo "Found hadoop home in bashrc"
				HADOOP_HOME=$(grep "HADOOP_HOME=" "${BASH_FILE}" | cut -d '=' -f2-) 2>/dev/null
				echo "Hadoop Home:" $HADOOP_HOME
			else
				echo "Could not find hadoop home in ~/.bashrc"
				SOFT_LINK_HADOOP=$(which hadoop)
				if [[ -f "$SOFT_LINK_HADOOP" ]]; then
					CURRENT_HADOOP_BIN=$(ls -lrt ${SOFT_LINK_HADOOP} |  awk '{print $11}') 2>/dev/null
					CURRENT_TRIM_STRING="/current/hadoop-client/bin/hadoop"
					HADOOP_HOME_SOFT_LINK_2=${CURRENT_HADOOP_BIN//$CURRENT_TRIM_STRING/}
					if [[ -f "$HADOOP_HOME_SOFT_LINK_2" ]]; then
						CURRENT_HADOOP_BIN=$(ls -lrt ${HADOOP_HOME_SOFT_LINK_2} |  awk '{print $11}') 2>/dev/null
						CURRENT_TRIM_STRING="/bin/hadoop"
						HADOOP_HOME=${CURRENT_HADOOP_BIN//$CURRENT_TRIM_STRING/}
						echo "Hadoop Home:" $HADOOP_HOME
						if [[ -d "${HADOOP_HOME}/lib/spark" ]]; then
							if [[ -z "${SPARK_HOME}" ]]; then
								SPARK_HOME="${HADOOP_HOME}/lib/spark"
							fi
						elif [[ -d "${HADOOP_HOME}/lib/spark2" ]]; then
							if [[ -z "${SPARK_HOME}" ]]; then
								SPARK_HOME="${HADOOP_HOME}/lib/spark"
							fi
						fi
					fi
				else
					echo "Not able to locate hadoop home. Please enter it manually"
				fi
			fi
			popd 1>/dev/null
		else
			echo "Using hadoop home environment variable"
			echo "Hadoop Home:" $HADOOP_HOME
		fi

		if [[ -z "${SPARK_HOME}" ]]; then
			echo "Spark home not set as environmental variable"
			pushd ~ 1>/dev/null
			BASH_FILE=.bashrc
			if grep -q "SPARK_HOME" "$BASH_FILE" 2>/dev/null; then
			echo "Found spark home in bashrc"
				SPARK_HOME=$(grep "SPARK_HOME=" "${BASH_FILE}" | cut -d '=' -f2-)
				echo "Spark Home:" $SPARK_HOME
			else
				echo "Could not find spark home in ~/.bashrc"
				SPARK_START_MASTER_PATH=$(sudo find / -path "*infoworks*" -prune -o -name start-master.sh -print) 2>/dev/null
				if [[ -z "$SPARK_START_MASTER_PATH" ]] 2>/dev/null; then 
					echo "Not able to locate spark home. Please enter it manually"
				else
					SPARK_PATH_COUNT=$(sudo find / -path "*infoworks*" -prune -o -name start-master.sh -print |wc -l) 2>/dev/null
					if [ "$SPARK_PATH_COUNT" -gt 1 ] 2>/dev/null; then
						echo "More than one spark installation found"
						for i in "${SPARK_START_MASTER_PATH[@]}" 
						do
							# dir="$(dirname ${i})"
							# echo "$(dirname ${dir})"
							echo "${i}" | sed 's/\(spark.\).*/\1/g' 2>/dev/null
							var=$(echo $(echo "${i}" | sed 's/\(spark.\).*/\1/g') |  awk '{print $1}') 2>/dev/null
						done
						SPARK_HOME=$var
						echo "Selecting" $SPARK_HOME "as spark home"
					else
						SPARK_HOME=$( dirname $( cd "$( dirname "${SPARK_START_MASTER_PATH}" )" && pwd ) )
						# HADOOP_HOME=${SPARK_START_MASTER_PATH//$CURRENT_TRIM_STRING/}
						# echo "Hadoop Home:" $HADOOP_HOME
					    echo "Spark Home:" $SPARK_HOME
					fi
				fi
			fi
			popd 1>/dev/null
		else
			echo "Using spark home environment variable"
			echo "Spark Home:" $SPARK_HOME
		fi
	else
		if [[ -z "${HADOOP_HOME}" ]]; then
		  	echo "Hadoop home not set as environmental variable"
		  	pushd ~ 1>/dev/null
		  	BASH_FILE=.bashrc
		  	if grep -q "HADOOP_HOME" "$BASH_FILE"; then
		  		echo "Found hadoop home in bashrc"
			    HADOOP_HOME=$(grep "HADOOP_HOME=" "${BASH_FILE}" | cut -d '=' -f2-) 2>/dev/null
			    echo "Hadoop Home:" $HADOOP_HOME
			else
			    echo "Could not find hadoop home in ~/.bashrc"
			    SOFT_LINK_HADOOP=$(which hadoop)
			    if [[ -f "$SOFT_LINK_HADOOP" ]]; then
			    	CURRENT_HADOOP_BIN=$(ls -lrt ${SOFT_LINK_HADOOP} |  awk '{print $11}') 2>/dev/null
			    	CURRENT_TRIM_STRING="/current/hadoop-client/bin/hadoop"
			    	HADOOP_HOME=${CURRENT_HADOOP_BIN//$CURRENT_TRIM_STRING/}
			    	echo "Hadoop Home:" $HADOOP_HOME
			  		# if [[ -d "${HADOOP_HOME}/current/spark-client" ]]; then
					# 	if [[ -z "${SPARK_HOME}" ]]; then
					# 		SPARK_HOME="${HADOOP_HOME}/current/spark-client"
					# 	fi
					# fi
			    else
			    	echo "Not able to locate hadoop home. Please enter it manually"
			    fi
			fi
			popd 1>/dev/null
		else
			echo "Using hadoop home environment variable"
			echo "Hadoop Home:" $HADOOP_HOME
		fi

		if [[ -z "${SPARK_HOME}" ]]; then
			echo "Spark home not set as environmental variable"
			pushd ~ 1>/dev/null
			BASH_FILE=.bashrc
			if grep -q "SPARK_HOME" "$BASH_FILE" 2>/dev/null; then
			echo "Found spark home in bashrc"
				SPARK_HOME=$(grep "SPARK_HOME=" "${BASH_FILE}" | cut -d '=' -f2-)
				echo "Spark Home:" $SPARK_HOME
			else
				echo "Could not find spark home in ~/.bashrc"
				SPARK_START_MASTER_PATH=$(sudo find / -path "*infoworks*" -prune -o -name start-master.sh -print) 2>/dev/null
				if [[ -z "$SPARK_START_MASTER_PATH" ]] 2>/dev/null; then 
					echo "Not able to locate spark home. Please enter it manually"
				else
					SPARK_PATH_COUNT=$(sudo find / -path "*infoworks*" -prune -o -name start-master.sh -print |wc -l) 2>/dev/null
					if [ "$SPARK_PATH_COUNT" -gt 1 ] 2>/dev/null; then
						echo "More than one spark installation found"
						for i in "${SPARK_START_MASTER_PATH[@]}"
						do
							# dir="$(dirname ${i})"
							# echo "$(dirname ${dir})"
							echo "${i}" | sed 's/\(spark.\).*/\1/g'
							var=$(echo $(echo "${i}" | sed 's/\(spark.\).*/\1/g') |  awk '{print $1}') 2>/dev/null
						done
						SPARK_HOME=$var
						echo "Selecting" $SPARK_HOME "as spark home"
					else
						SPARK_HOME=$( dirname $( cd "$( dirname "${SPARK_START_MASTER_PATH}" )" && pwd ) )
						# HADOOP_HOME=${SPARK_START_MASTER_PATH//$CURRENT_TRIM_STRING/}
						# echo "Hadoop Home:" $HADOOP_HOME
					    echo "Spark Home:" $SPARK_HOME
					fi
				fi
			fi
			popd 1>/dev/null
		else
			echo "Using spark home environment variable"
			echo "Spark Home:" $SPARK_HOME
		fi
	fi
}
_get_hadoop_spark_home

python set_home.py $HADOOP_HOME $SPARK_HOME
