CREATE SEQUENCE audit_log_seq;

CREATE TABLE IF NOT EXISTS audit_log (
  id bigint NOT NULL DEFAULT NEXTVAL ('audit_log_seq'),
  create_time timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  query_id varchar(256) DEFAULT NULL,
  command_type varchar(64) DEFAULT NULL,
  command text,
  inputs text,
  outputs text,
  username varchar(64) DEFAULT NULL,
  ip varchar(64) DEFAULT NULL,
  extras text,
  PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS audit_log_create_time_index ON audit_log (create_time);



CREATE SEQUENCE mapred_stats_seq;

CREATE TABLE IF NOT EXISTS mapred_stats (
  id bigint NOT NULL DEFAULT NEXTVAL ('mapred_stats_seq'),
  create_time timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  audit_log_id bigint NOT NULL,
  stage varchar(256) NOT NULL,
  mappers bigint NOT NULL,
  reducers bigint NOT NULL,
  cpu_time bigint NOT NULL,
  counters text DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS mapred_stats_seq_create_time_index ON mapred_stats (create_time);
CREATE INDEX IF NOT EXISTS mapred_stats_seq_audit_log_id_index ON mapred_stats (audit_log_id);



CREATE SEQUENCE audit_objects_seq;

CREATE TABLE IF NOT EXISTS audit_objects (
  id bigint NOT NULL DEFAULT NEXTVAL ('audit_objects_seq'),
  create_time timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  audit_log_id bigint NOT NULL,
  category varchar(64) DEFAULT NULL,
  type varchar(64) DEFAULT NULL,
  name varchar(4000) DEFAULT NULL,
  serialized_object text,
  PRIMARY KEY (id)
);

CREATE INDEX IF NOT EXISTS audit_objects_create_time_index ON audit_objects (create_time);
CREATE INDEX IF NOT EXISTS audit_objects_seq_audit_log_id_index ON audit_objects (audit_log_id);



CREATE SEQUENCE replication_jobs_seq;

CREATE TABLE IF NOT EXISTS replication_jobs (
  id bigint NOT NULL DEFAULT NEXTVAL ('replication_jobs_seq'),
  create_time timestamp(0) NULL DEFAULT '1111-11-11 11:11:11',
  update_time timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  operation varchar(128) DEFAULT NULL,
  status varchar(128) DEFAULT NULL,
  src_path varchar(4000) DEFAULT NULL,
  src_cluster varchar(256) DEFAULT NULL,
  src_db varchar(1024) DEFAULT NULL,
  src_table varchar(1024) DEFAULT NULL,
  src_partitions text,
  src_tldt varchar(4000) DEFAULT NULL,
  rename_to_db varchar(1024) DEFAULT NULL,
  rename_to_table varchar(1024) DEFAULT NULL,
  rename_to_partition varchar(4000) DEFAULT NULL,
  rename_to_path varchar(4000) DEFAULT NULL,
  extras text,
  PRIMARY KEY (id)
);

  CREATE INDEX IF NOT EXISTS update_time_index ON replication_jobs (update_time);
  CREATE INDEX IF NOT EXISTS src_cluster_index ON replication_jobs (src_cluster);
  CREATE INDEX IF NOT EXISTS src_db_index ON replication_jobs (src_db);
  CREATE INDEX IF NOT EXISTS src_table_index ON replication_jobs (src_table);


CREATE TABLE IF NOT EXISTS key_value (
  update_time timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  key_string varchar(128) NOT NULL,
  value_string varchar(4000) DEFAULT NULL,
  PRIMARY KEY (key_string)
);
