SCRIPT_LOC="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# get the linux type

if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
elif [ -f /etc/lsb-release ]; then
    # For some versions of Debian/Ubuntu without lsb_release command
    . /etc/lsb-release
    OS=$DISTRIB_ID
elif [ -f /etc/debian_version ]; then
    # Older Debian/Ubuntu/etc.
    OS=Debian
elif [ -f /etc/redhat-release ]; then
    # Older Red Hat, CentOS, etc.
    OS=CentOS
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    echo "Fall back to uname -s to detect OS version"
    OS=$(uname -s)
fi

if [ "$OS" = "CentOS" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36/bin
elif [ "$OS" = "Ubuntu" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-ubuntu/bin
elif [ "$OS" = "Debian GNU/Linux" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-debian/bin
elif [ "$OS" == "SLES" ]; then
  export PY_PATH=${SCRIPT_LOC}/resources/python36-suse/bin
else
  export PY_PATH=${SCRIPT_LOC}/resources/python36/bin
fi

echo "Found OS: ${OS}"
echo "Using Python Path: ${PY_PATH}"

export PATH=$PY_PATH:$PATH
if [[ "$IW_PLATFORM" = "saas" || "$IW_PLATFORM" = "marketplace" ]]; then
    echo "Found IW_PLATFORM: saas"
    python ${SCRIPT_LOC}/upgrade/driver_saas.py $@
else
    python ${SCRIPT_LOC}/upgrade/driver.py $@
fi
exit $?
